export class BasePage extends $falcon.Page {
  constructor() {
    super()
  }

  /**
   * 页面生命周期:首次启动
   * @param {Object} options 页面启动参数
   */
   onLoad(options) {
    super.onLoad(options)
    // 此时 $root 还没有初始化，该函数后面就是 $root 创建和 created mounted 生命周期
  }

  /**
   * 页面生命周期:页面重新进入
   * 其他应用或者系统通过$falcon.navTo()方法重新启动页面.可以通过这个回调拿到新启动的参数
   * @param {Object}} options 重新启动参数
   */
  onNewOptions(options) {
    super.onNewOptions(options)
    this.$root.onNewOptions && this.$root.onNewOptions(options)
  }

  /**
   * 页面生命周期:页面进入前台
   */
  onShow() {
    super.onShow()
    this.$root.onShow && this.$root.onShow()
  }
  
  /**
   * 页面生命周期:页面进入后台
   */
  onHide() {
    super.onHide()
    this.$root.onHide && this.$root.onHide()
  }

  /**
   * 页面生命周期:页面卸载
   */
  onUnload() {
    super.onUnload()
    this.$root.onUnload && this.$root.onUnload()
  }
}